package org.gualdi.grails.plugins.cookiechoices

import grails.util.Holders

class CookiechoicesTagLib {

  static namespace = "cookiechoices"

  def render = { attrs ->
    def type = attrs?.type ?: "bar" // bar | dialog
    def message = attrs?.message ?: 'Utilizziamo i cookie per migliorare la tua esperienza sul nostro sito. Se continui la navigazione intendiamo che tu condivida questo utilizzo.'
    def close = attrs?.close ?: 'Accetta'
    def learn = attrs?.learn ?: ''
    def learnURL = attrs?.url ?: ''
    def style = attrs?.style ?: ''
    out << renderHtml(type, message, close, learn, learnURL, style)
  }

  private String renderHtml(String type, String message, String close, String learn, String learnURL, String style) {
    StringBuilder sb = new StringBuilder()

    String function
    String cssStyle
    if (type == 'bar') {
      function = 'showCookieConsentBar'
      cssStyle = style ?: 'background-color:#eee;'
    }
    else {
      function = 'showCookieConsentDialog'
      cssStyle = style ?: 'background-color:#fff;'
    }

    sb << """<script src="${getPluginResourcePath()}/js/cookiechoices.js"></script>"""
    sb << """<script>"""
    sb << """  document.addEventListener('DOMContentLoaded', function(event) {"""
    sb << """  cookieChoices.${function}('${message.encodeAsJavaScript()}', '${close.encodeAsJavaScript()}', '${learn.encodeAsJavaScript()}', '${learnURL}', '${cssStyle}');"""
    sb << """});"""
    sb << """</script>"""

    return sb.toString()
  }

  private String getPluginResourcePath() {
    def pluginName = "cookiechoices"
    String pluginVersion = Holders.pluginManager.getGrailsPlugin(pluginName)?.version
    return "${request.contextPath}/plugins/${pluginName.toLowerCase()}-$pluginVersion"
  }
}
