/*
*
* Copyright 2015 Stefano Gualdi
*
*   Licensed under the Apache License, Version 2.0 (the "License");
*   you may not use this file except in compliance with the License.
*   You may obtain a copy of the License at
*
*       http://www.apache.org/licenses/LICENSE-2.0
*
*   Unless required by applicable law or agreed to in writing, software
*   distributed under the License is distributed on an "AS IS" BASIS,
*   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*   See the License for the specific language governing permissions and
*   limitations under the License.
*
*/

class CookiechoicesGrailsPlugin {
  def version = "1.0"

  def grailsVersion = "2.2 > *"

  def pluginExcludes = [
    "grails-app/views/index.gsp",
    "grails-app/views/error.gsp",
    "grails-app/conf/UrlMappings.groovy"
  ]

  def title = "Cookiechoices Plugin"
  def author = "Stefano Gualdi"
  def authorEmail = "stefano.gualdi@gmail.com"
  def description = '''\
Simple plugin to notify users about the use of cookies in your site.
'''

  def documentation = "http://grails.org/plugin/cookiechoices"

  def license = "APACHE"

  def organization = [name: "Stefano Gualdi", url: "http://gualdi.org/"]

  def scm = [url: "https://github.com/stefanogualdi/grails-cookiechoices"]
}
